(*|  9:49  9/10/1989 *)
UNIT StdTypes;

{GLOBAL DEFINITIONS ETC.}

INTERFACE

TYPE
  LineString = String[80];    {general string type}
  Maxstring = String[255];    {maximum length string type}

  TimeType= RECORD
              Hours,Mins,Secs,Tenths: Byte;
            END;

  TimeStrType = String[5];

  DateType= RECORD
              Day,Month,Year: Integer;
            END;

  DateStrType = String[8];

  Keytype= (none,Inval,Normal,F1,F2,F3,F4,F5,F6,F7,F8,F9,F10,BS,Ret,Tab,Esc,
            Cleft,Cright,Cup,Cdown,Chome,Cend,Cpgup,Cpgdown,Cins,Cdel,RTab,
            CtlF1,CtlF2,CtlF3,CtlF4,CtlF5,CtlF6,CtlF7,CtlF8,CtlF9,CtlF10,
            ShF1,ShF2,ShF3,ShF4,ShF5,ShF6,ShF7,ShF8,ShF9,ShF10,
            AltF1,AltF2,AltF3,AltF4,AltF5,AltF6,AltF7,AltF8,AltF9,AltF10,
            CCenter,AltD,AltH,AltP,AltT);

  Day = (Mon,Tue,Wed,Thu,Fri,Sat,Sun);
  Week = SET OF Day;

  ScrnChar = RECORD     {format of character on screen}
               Ch: Char;       {character code}
               Attrib: Byte;   {attributes}
             END;

CONST
  ZeroTime: TimeType =(Hours:0; Mins:0; Secs:0; Tenths:0);
  {ASCII control codes:}
  SOH= #1;
  STX= #2;
  ETX= #3;
  EOT= #4;
  ENQ= #5;
  ACK= #6;
  LF=  #$0A;
  FF=  #$0C;
  CR=  #$0D;
  SO=  #$0E;
  SI=  #$0F;
  NAK= #$15;
  ESCODE= #$1B;


IMPLEMENTATION
END.
